% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pfr-Ptot.r
\name{Pfr_Ptot}
\alias{Pfr_Ptot}
\alias{Pfr_Ptot.default}
\alias{Pfr_Ptot.numeric}
\alias{Pfr_Ptot.source_spct}
\title{Calculate phytochrome photoequilibrium}
\usage{
Pfr_Ptot(x, ...)

\method{Pfr_Ptot}{default}(x, ...)

\method{Pfr_Ptot}{numeric}(x, spct.out = length(x) > 20, ...)

\method{Pfr_Ptot}{source_spct}(x, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{not used}

\item{spct.out}{logical Flag indicating if the returned object should be of
class \code{response_spct} instead of \code{numeric}.}
}
\value{
If \code{x} is \code{numeric}, giving wavelengths (nm), a vector of
  numeric values giving the unitless photon ratio at each wavelength or a
  \code{generic_spct} object with the wavelength values sorted in ascending
  order and the corresponding \code{Pfr_Ptot} values in column
  \code{s.q.response}.

If \code{x} is a \code{source_spct} object, a single numeric value
  giving the unitless photon ratio
}
\description{
A method implemented for objects of different classes.
}
\section{Methods (by class)}{
\itemize{
\item \code{Pfr_Ptot(default)}: Default for generic function

\item \code{Pfr_Ptot(numeric)}: Specialization for numeric

\item \code{Pfr_Ptot(source_spct)}: Specialization for source_spct

  Calculate phytochrome photoequilibrium from spectral (photon) irradiance

}}
\note{
If you use these data in a publication, please cite also the original
  source as given under references.
}
\references{
Mancinelli, A.L. (1994) The physiology of phytochrome action. In
Photomorphogenesis in plants, 2nd edition. R.E. Kendrick and G.H.M.
Kronenberg, eds. Kluwer Academic Publishers, Dordrecht, pp. 211-269. ISBN
978-0-7923-2551-2 (print), 978-94-011-1884-2 (on-line).
\doi{10.1007/978-94-011-1884-2_10}
}
