% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp-uvb313-temp.r
\docType{data}
\name{qp_uvb313_temp.spct}
\alias{qp_uvb313_temp.spct}
\title{Spectral irradiance of UVB lamps at different temperatures.}
\format{A \code{"source_spct"} object with 777 rows (290 nm to 400 nm, 1.0 nm step) and 3
  variables.

The variables are as follows:
\itemize{
  \item temperature (C)
  \item w.length (nm)
  \item s.e.irrad (W m-2 nm-1)
}}
\usage{
qp_uvb313_temp.spct
}
\description{
Dataset of spectral irradiance from a set of two Q-Panel UVB-313 40W
fluorescent tubes, measured at different temperatures.
}
\details{
Absolute values are comparable among the different temperatures. The lamps
and the cosine diffuser were located inside a Conviron growth chamber. The
measurements were done with a recently calibrated Macam double-monochromator
spectroradiometer located outside the chamber and maintained at constant room
temperature of 22 C. After each change in the temperature controller
set-point enough time was allowed after the temperature had stabilized inside
the chamber, for the output of the lamps to also become stable.
}
\note{
Instrument used: Macam SR-9010-PC scanning double monochromator
spectroradiometer with a cosine corrected input optics. Recently calibrated.
The lamps were driven by a high frequency electronic ballast.
}
\references{
Aphalo, P J, R Tegelberg, and R Julkunen-Tiitto. 1999. The
Modulated UV-B Irradiation System at the University of Joensuu.” Biotronics
28: 109–120.
\url{http://ci.nii.ac.jp/naid/110006175827/en}.
}
\keyword{datasets}

