% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-cid-spectravue-csv.r
\name{read_cid_spectravue_csv}
\alias{read_cid_spectravue_csv}
\title{Read File Saved by CID's SpectraVue.}
\usage{
read_cid_spectravue_csv(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale(),
  range = c(380, 1100),
  simplify = TRUE,
  absorbance.to = "object",
  strict.range = NA,
  ...
)
}
\arguments{
\item{file}{character}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date and time are extracted
from the file.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}. If \code{NULL}, the default, the
geocode is extracted from the file, if present, and if \code{NA} the
"where.measured" attribute is not set.}

\item{label}{character string. If \code{NULL}, the default, the value of the
"tag" present in the file is used, and if \code{NA} the "what.measured"
attribute is not set.}

\item{tz}{character Time zone is by default that of the machine's locale.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{range}{numeric A vector of length two, or any other object for which
function code{range()} will return range of wavelengths expressed in
nanometres.}

\item{simplify}{logical If TRUE, single spectra are returned as individual
spectra instead of collections of length one.}

\item{absorbance.to}{character Affects only absorbance measurements:
\code{"object"}, \code{"all"} or \code{"A"}.}

\item{strict.range}{logical Flag indicating whether off-range values result
in an error (\code{TRUE}) instead of a warning (\code{FALSE}), or the test
is disabled (\code{NA}).}

\item{...}{additional arguments passed to the constructor of the
`filter_spct` object.}
}
\value{
An object of class \code{filter_spct}, \code{relector_spct},
  \code{object_spct} or \code{generic_mspct}.
}
\description{
Read wavelength and spectral data from Measurements.CSV files exported from
CID Bio-Sciences' \strong{SpectraVue CI-710s} (not the older CI-710!) leaf
spectrometer, importing them into R. Available metadata is also extracted
from the file. \code{read_cid_spectravue_csv()} only accepts "row oriented"
CSV files. These may contain multiple spectra, one per row.
}
\details{
SpectraVue's row-wise spectral \code{Measurements.CSV} files contain
  columns with metadata on the right edge, followed by columns with data for
  each of the 2048 pixels or wavelengths. The value in column "Mode"
  indicates the quantity measured, decoded into variables \code{Tpc},
  \code{Rpc} or \code{A}. The data the rows in the CSV file are read and
  stored in \code{filter_spct},  \code{reflector_spct} or \code{object_spct}
  objects. These objects are collected into a single \code{filter_mspct},
  \code{reflector_mspct}, \code{object_mspct} or \code{generic_spct} object
  and returned.

  Spectral data outside the range 400 nm to 1000 nm are very noisy and thus
  outside the valid range for the measurements. Out-of-range spectral data
  can also be cause by calibration drift. Consequently, reading of data is
  done always with the range check disabled, while whether a check is used
  before returning the collection of spectra depends on the argument passed
  to \code{strict.range} which by default is set to disable checks. This is
  done, because in most cases measurements from this instrument tend to
  require further processing before they comply with theoretical expectations
  of \eqn{Tfr + Rfr + Afr = 1}.
}
\note{
SpectraVue creates three or four \code{.CSV} files for each series of
  measurements saved. Of these files, this function reads the one with name
  ending in \code{Measurements.CSV}. The first part of the file name gives
  the time of the session, but as the files can contain multiple spectra
  measured at different times, the time metadata is extracted separately for
  each spectrum. We provide a default argument for \code{range} that discards
  data for short and long wavelengths because values outside this range are
  according to the instrument's manual outside the usable range and in
  practice extremely noisy.
}
\section{Internal \emph{vs.} total transmittance and absorbance}{
 Spectravue
  returns transmittance values labelled with \code{Transmittance} as
  \code{Mode}. Transmittance values are not \emph{total} as most of the
  scattered light transmitted is not detected. Absorbance (\code{Abs}) values
  returned labelled with \code{Absorbance} as \code{Mode} are for absorbance
  computed from the Transmittance. This estimate of absorbance overestimates
  real absorbance in the case of scattering materials like plant leaves. It
  is best to save spectral data acquired as absorbance into objects of class
  `object_spct` containing reflectance and transmittance, the default, as
  this preserves all the acquired data.
}

\section{Specular \emph{vs.} total reflectance}{
 This function assumes that
  SpectraVue returns close to \emph{total} reflectance readings. Given the optics
  of the instrument this is likely only an approximation.
}

\section{Warning!!}{

CID's support has answered on 2022-05-19 that the extremely biased (plainly
wrong!) values of transmittance measured by this instrument are due to a
design flaw and that they are working on a solution for the problem. In
practice, reflectance seems biased but usable as an instrument-specific
quantity with arbitrary units. Transmittance and absorbance seem useless as
values are wrong by about an order of magnitude.
}

\examples{

# read file containing a single reflectaance spectrum

 file.name <-
   system.file("extdata", "cid-spectravue-Rpc-Measurements.csv",
               package = "photobiologyInOut", mustWork = TRUE)

 cid_filter.spct <-
   read_cid_spectravue_csv(file = file.name)
 summary(cid_filter.spct)

 cid_filter.spct <-
   read_cid_spectravue_csv(file = file.name, simplify = FALSE)
 summary(cid_filter.spct)

 # read data measured as absorbance (A, Rpc and Tpc)

 file.name <-
   system.file("extdata", "cid-spectravue-Abs-Measurements.csv",
               package = "photobiologyInOut", mustWork = TRUE)
 cid.object_spct <-
   read_cid_spectravue_csv(file = file.name)
 summary(cid.object_spct)

 cid_A.filter_spct <-
   read_cid_spectravue_csv(file = file.name, absorbance.to = "A")
 summary(cid_A.filter_spct)

}
\references{
\url{https://cid-inc.com/}
}
