% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-licor-prn.r
\name{read_licor_prn}
\alias{read_licor_prn}
\alias{read_m_licor_prn}
\title{Read '.PRN' File(s) Saved by LI-COR's PC1800 Program.}
\usage{
read_licor_prn(file, date = NULL, geocode = NULL, label = NULL,
  tz = NULL, locale = readr::default_locale(), s.qty = NULL)

read_m_licor_prn(files, date = NULL, geocode = NULL, label = NULL,
  tz = Sys.timezone(), locale = readr::default_locale(),
  s.qty = NULL)
}
\arguments{
\item{file}{Path to file as a character string.}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is extracted from the
file header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the
file header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{s.qty}{character The name of the spectral quantity to be read. One of
"s.irrad", "Tfr", or "Rfr".}

\item{files}{A list or vector of character strings.}
}
\value{
\code{read_licor_prn()} returns a \code{source_spct} object with
  \code{time.unit} attribute set to \code{"second"} and \code{when.measured}
  attribute set to the date-time extracted from the file name, or supplied.

Function \code{read_m_licor_prn()} returns a source_mspct object
  containing one spectrum per file read.
}
\description{
Reads and parses the header of a processed data file as output by the PC1800
program to extract the whole header remark field and also decode whether data
is in photon or energy based units. The time field is ignored as it does not
contain year information. This instrument is no longer being manufactured.
}
\details{
Function \code{read_m_licor_prn()} calls \code{red_licor_file()} 
  for each file in \code{files}. See \code{\link[readr]{read_table}} for
  a description of valid arguments for \code{files}.
}
\note{
The LI-1800 spectroradiometer does not store the year as part of the
data, only month, day, and time of day. Because of this, in the current
version, if \code{NULL} is the argument to date, year is set to 0000.
}
\references{
\url{https://www.r4photobiology.info} \url{https://www.licor.com}
}
\keyword{misc}
