#' Indexing of cellulose di-acetate films from Courtaulds
#'
#' Vectors of names of member objects containing spectral transmittance data for
#' Courtaulds di-acetate films of different thickness.
#'
#' @details 1) Films (0.115 mm thick) stretched 25 cm below Q-Panel UVB313 lamps
#'   and exposed to UV radiation from different lengths of time per day. All
#'   films were installed and sampled at the same time inside a greenhouse. The
#'   digits give the number of minutes per day that the lamps were on.
#'
#'   2) New films of different thickness.
#'
#' @note Individual measurements of single samples, not a specification.
#'   Instrument used: Hewlett-Packard 8453 diode array spectrophotometer without
#'   an integrating sphere. These films are no longer available, but similar
#'   material from other suppliers may be still available.
#'
#' @docType data
#' @keywords datasets
#'
#' @format A vector of character strings.
#'
#' @seealso \code{\link{filters.mspct}}
#'
#' @examples
#' courtaulds_filters
#'
"courtaulds_filters"
