% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.absorbance.R
\name{absorbance}
\alias{absorbance}
\alias{absorbance.default}
\alias{absorbance.filter_mspct}
\alias{absorbance.filter_spct}
\alias{absorbance.object_mspct}
\alias{absorbance.object_spct}
\title{Absorbance}
\usage{
absorbance(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorbance}{default}(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{absorbance}{filter_spct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)

\method{absorbance}{object_spct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)

\method{absorbance}{filter_mspct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...,
  idx = !is.null(names(spct)))

\method{absorbance}{object_mspct}(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...,
  idx = !is.null(names(spct)))
}
\arguments{
\item{spct}{an R object}

\item{w.band}{waveband or list of waveband objects or a numeric vector of
length two. The waveband(s) determine the region(s) of the spectrum that
are summarized. If a numeric range is supplied a waveband object is
constructed on the fly from it.}

\item{quantity}{character}

\item{wb.trim}{logical Flag indicating if wavebands crossing spectral data
boundaries are trimmed or ignored}

\item{use.hinges}{logical Flag indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments (possibly ignored)}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\description{
Function to calculate the mean, total, or other summary of absorbance for
spectral data stored in a \code{filter_spct} or in an \code{object_spct}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{filter_spct}: Specialization for filter spectra

\item \code{object_spct}: Specialization for object spectra

\item \code{filter_mspct}: Calculates absorbance from a \code{filter_mspct}

\item \code{object_mspct}: Calculates absorbance from a \code{object_mspct}
}}
\note{
The \code{use.hinges} parameter controls speed optimization. The
  defaults should be suitable in most cases. Only the range of wavelengths in
  the wavebands is used and all BSWFs are ignored.
}
\examples{
absorbance(polyester.spct, new_waveband(400,700))
absorbance(yellow_gel.spct, new_waveband(400,700))

}

