% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.transmittance.r
\name{transmittance.filter_mspct}
\alias{transmittance}
\alias{transmittance.default}
\alias{transmittance.filter_mspct}
\alias{transmittance.filter_spct}
\alias{transmittance.object_mspct}
\alias{transmittance.object_spct}
\title{Transmittance}
\usage{
\method{transmittance}{filter_mspct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ..., idx = !is.null(names(spct)))

\method{transmittance}{object_mspct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ..., idx = !is.null(names(spct)))

transmittance(spct, w.band, quantity, wb.trim, use.hinges, ...)

\method{transmittance}{default}(spct, w.band, quantity, wb.trim, use.hinges,
  ...)

\method{transmittance}{filter_spct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ...)

\method{transmittance}{object_spct}(spct, w.band = NULL,
  quantity = "average", wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ...)
}
\arguments{
\item{spct}{an R object}

\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the region(s) of the spectrum that are summarized.}

\item{quantity}{character}

\item{wb.trim}{logical Flag indicating if wavebands crossing spectral data boundaries
are trimmed or ignored}

\item{use.hinges}{logical Flag indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
A numeric vector with no change in scale factor
}
\description{
Summary transmittance for supplied wavebands from filter or object spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{filter_mspct}: Calculates transmittance from a \code{filter_mspct}

\item \code{object_mspct}: Calculates transmittance from a \code{object_mspct}

\item \code{default}: Default method

\item \code{filter_spct}: Method for filter spectra

\item \code{object_spct}: Method for object spectra
}}
\note{
The \code{use.hinges} parameter controls speed optimization. The
  defaults should be suitable in mosts cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\examples{
transmittance(polyester.spct, waveband(c(280, 315)))
transmittance(polyester.spct, waveband(c(315, 400)))
transmittance(polyester.spct, waveband(c(400, 700)))

}

