% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.normalize.r
\name{normalize}
\alias{normalize}
\alias{normalize.default}
\alias{normalize.filter_mspct}
\alias{normalize.filter_spct}
\alias{normalize.reflector_mspct}
\alias{normalize.reflector_spct}
\alias{normalize.response_mspct}
\alias{normalize.response_spct}
\alias{normalize.source_mspct}
\alias{normalize.source_spct}
\title{Normalize spectral data}
\usage{
normalize(x, ...)

\method{normalize}{default}(x, ...)

\method{normalize}{source_spct}(x, ..., range = NULL, norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"))

\method{normalize}{response_spct}(x, ..., range = NULL, norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"))

\method{normalize}{filter_spct}(x, ..., range = NULL, norm = "max",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"))

\method{normalize}{reflector_spct}(x, ..., range = NULL, norm = "max",
  qty.out = NULL)

\method{normalize}{source_mspct}(x, ..., range = NULL, norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"))

\method{normalize}{response_mspct}(x, ..., range = NULL, norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"))

\method{normalize}{filter_mspct}(x, ..., range = NULL, norm = "max",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"))

\method{normalize}{reflector_mspct}(x, ..., range = x, norm = "max",
  qty.out = NULL)
}
\arguments{
\item{x}{An R object}

\item{...}{not used in current version}

\item{range}{An R object on which \code{range()} returns a numeric vector of
length 2 with the limits of a range of wavelengths in nm, with min annd max
wavelengths (nm)}

\item{norm}{numeric Normalization wavelength (nm) or character string "max",
or "min" for normalization at the corresponding wavelngth, or "integral" or
"mean" for rescaling by dividing by these values.}

\item{unit.out}{character Allowed values "energy", and "photon",
or its alias "quantum"}

\item{qty.out}{character string  Allowed values are "transmittance", and
"absorbance" indicating on which quantity to apply the normalization.}
}
\value{
A new object of the same class as \code{x}.
}
\description{
These functions return a spectral object of the same class as the one
supplied as argument but with the spectral data normalized to 1.o a certain
wavelength.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Normalize a \code{source_spct} object.

\item \code{response_spct}: Normalize a response spectrum.

\item \code{filter_spct}: Normalize a filter spectrum.

\item \code{reflector_spct}: Normalize a reflector spectrum.

\item \code{source_mspct}: Normalize the members of a source_mspct object.

\item \code{response_mspct}: Normalize the members of a response_mspct object.

\item \code{filter_mspct}: Normalize the members of a filter_mspct object.

\item \code{reflector_mspct}: Normalize the members of a reflector_mspct object.
}}
\note{
Accepted values for \code{norm} vary depending on the class of
  \code{x}
}
\seealso{
Other rescaling functions: \code{\link{fscale}},
  \code{\link{fshift}}, \code{\link{getNormalized}},
  \code{\link{is_normalized}}, \code{\link{is_scaled}},
  \code{\link{setNormalized}}, \code{\link{setScaled}}
}

