% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.classes.r, R/spct.summaries.r
\name{getWhenMeasured.generic_mspct}
\alias{getWhenMeasured}
\alias{getWhenMeasured.default}
\alias{getWhenMeasured.generic_mspct}
\alias{getWhenMeasured.generic_spct}
\alias{getWhenMeasured.summary_generic_spct}
\title{Get the "when.measured" attribute}
\usage{
\method{getWhenMeasured}{generic_mspct}(x, ..., idx = !is.null(names(x)))

getWhenMeasured(x, ...)

\method{getWhenMeasured}{default}(x, ...)

\method{getWhenMeasured}{generic_spct}(x, ...)

\method{getWhenMeasured}{summary_generic_spct}(x, ...)
}
\arguments{
\item{x}{a generic_spct object}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
POSIXct An object with date and time.
}
\description{
Function to read the "when.measured" attribute of an existing generic_spct
or a generic_mspct.
}
\section{Methods (by class)}{
\itemize{
\item \code{generic_mspct}: generic_mspct

\item \code{default}: default

\item \code{generic_spct}: generic_spct

\item \code{summary_generic_spct}: summary_generic_spct
}}
\note{
The method for collections of spectra returns the
  a data_frame with the correct times in TZ = "UTC".

If x is not a \code{generic_spct} or an object of a derived class
  \code{NA} is returned.
}
\examples{
getWhenMeasured(sun.spct)

}
\seealso{
Other measurement metadata functions: \code{\link{getInstrDesc}},
  \code{\link{getInstrSettings}},
  \code{\link{getWhereMeasured.generic_mspct}},
  \code{\link{setInstrDesc}},
  \code{\link{setInstrSettings}},
  \code{\link{setWhenMeasured.generic_mspct}},
  \code{\link{setWhereMeasured.generic_mspct}}
}

