% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun.calc.r
\name{sun_angles}
\alias{sun_angles}
\title{Solar angles}
\usage{
sun_angles(time = lubridate::now(), geocode = NULL, lon = 0, lat = 0,
  use_refraction = FALSE)
}
\arguments{
\item{time}{POSIXct Time, any valid time zone (TZ) is allowed, default is
current time}

\item{geocode}{data frame with variables lon and lat as numeric values
(degrees).}

\item{lon}{numeric Vector of longitudes (degrees)}

\item{lat}{numeric Vector of latitudes (degrees)}

\item{use_refraction}{logical Flag indicating whether to correct for
fraction in the atmosphere}
}
\value{
A list with components time in same TZ as input, azimuth, elevation,
  diameter, and distance.
}
\description{
This function returns the solar angles for a given time and location.
}
\examples{
require(lubridate)
sun_angles()
sun_angles(ymd_hms("2014-09-23 12:00:00"))
sun_angles(ymd_hms("2014-09-23 12:00:00"), lat=60, lon=0)

}
\seealso{
Other astronomy related functions: \code{\link{day_night}}
}

