% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.response.R
\name{q_response.response_mspct}
\alias{q_response}
\alias{q_response.default}
\alias{q_response.response_mspct}
\alias{q_response.response_spct}
\title{Photon-based photo-response}
\usage{
\method{q_response}{response_mspct}(spct, w.band = NULL, quantity = "total",
  time.unit = NULL, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ..., idx = !is.null(names(spct)))

q_response(spct, w.band, quantity, time.unit, wb.trim, use.hinges, ...)

\method{q_response}{default}(spct, w.band, quantity, time.unit, wb.trim,
  use.hinges, ...)

\method{q_response}{response_spct}(spct, w.band = NULL, quantity = "total",
  time.unit = NULL, wb.trim = getOption("photobiology.waveband.trim",
  default = TRUE), use.hinges = getOption("photobiology.use.hinges", default =
  NULL), ...)
}
\arguments{
\item{spct}{an R object}

\item{w.band}{a waveband object or a list of waveband objects}

\item{quantity}{character}

\item{time.unit}{character or lubridate::duration}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
A single numeric value expressed either as a fraction of one or a
  percentage, or a vector of the same length as the list of wave.bands. The
  quantity returned, although always on photon-based units, depends on the
  value of \code{quantity}.
}
\description{
This function returns the mean response for a given
waveband and a response spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{response_mspct}: Calculates photon (quantum) response from a
\code{response_mspct}

\item \code{default}: Default method for generic function

\item \code{response_spct}: Method for response spectra.
}}
\note{
The parameter \code{use.hinges} controls speed optimization. The
  defaults should be suitable in mosts cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\examples{
q_response(ccd.spct, new_waveband(200,300))
q_response(photodiode.spct)

}
\seealso{
Other response functions: \code{\link{e_response.response_mspct}},
  \code{\link{response.response_mspct}}
}

