% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.absorptance.R
\name{absorptance_spct}
\alias{absorptance_spct}
\title{Calculate absorptance from spectral absorptance.}
\usage{
absorptance_spct(spct, w.band = NULL, quantity = "average",
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL))
}
\arguments{
\item{spct}{object_spct}

\item{w.band}{waveband or list of waveband objects The wavebands determine
the region(s) of the spectrum that are summarized.}

\item{quantity}{character string}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}
}
\description{
This function returns the summary absorptance for a given waveband of a
\code{object_spct} object
}
\keyword{internal}

