% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/photon.irradiance.r
\name{photon_irradiance}
\alias{photon_irradiance}
\title{Photon irradiance}
\usage{
photon_irradiance(w.length, s.irrad, w.band = NULL, unit.in = "energy",
  check.spectrum = TRUE, use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges", default = NULL))
}
\arguments{
\item{w.length}{numeric vector of wavelength (nm).}

\item{s.irrad}{numeric vector of spectral irradiances, by default as energy (W
m-2 nm-1).}

\item{w.band}{waveband.}

\item{unit.in}{character Values recognized "photon" or "energy".}

\item{check.spectrum}{logical Flag telling whether to sanity check input data,
default is TRUE.}

\item{use.cached.mult}{logical Flag telling whether multiplier values should be
cached between calls.}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}
}
\value{
A single numeric value with no change in scale factor: [mol s-1 m-2 nm-1]
  -> [mol s-1 m-2].
}
\description{
This function returns the photon irradiance for a given waveband of a
radiation spectrum, optionally applies a BSWF.
}
\examples{
with(sun.data, photon_irradiance(w.length, s.e.irrad))
with(sun.data, photon_irradiance(w.length, s.e.irrad, new_waveband(400,700)))

}
\seealso{
Other low-level functions operating on numeric vectors.: \code{\link{as_energy}},
  \code{\link{as_quantum_mol}},
  \code{\link{calc_multipliers}},
  \code{\link{div_spectra}},
  \code{\link{energy_irradiance}},
  \code{\link{energy_ratio}}, \code{\link{insert_hinges}},
  \code{\link{integrate_xy}},
  \code{\link{interpolate_spectrum}},
  \code{\link{irradiance}}, \code{\link{l_insert_hinges}},
  \code{\link{oper_spectra}}, \code{\link{photon_ratio}},
  \code{\link{photons_energy_ratio}},
  \code{\link{prod_spectra}}, \code{\link{s_e_irrad2rgb}},
  \code{\link{split_energy_irradiance}},
  \code{\link{split_photon_irradiance}},
  \code{\link{subt_spectra}}, \code{\link{sum_spectra}},
  \code{\link{trim_tails}}, \code{\link{v_insert_hinges}}
}
\concept{low-level functions operating on numeric vectors.}
