% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{check_spct}
\alias{check_spct}
\alias{check_spct.default}
\alias{check_spct.generic_spct}
\alias{check_spct.calibration_spct}
\alias{check_spct.raw_spct}
\alias{check_spct.cps_spct}
\alias{check_spct.filter_spct}
\alias{check_spct.reflector_spct}
\alias{check_spct.object_spct}
\alias{check_spct.response_spct}
\alias{check_spct.source_spct}
\alias{check_spct.chroma_spct}
\title{Check validity of spectral objects}
\usage{
check_spct(x, byref, strict.range, ...)

\method{check_spct}{default}(x, byref = FALSE, strict.range = NA, ...)

\method{check_spct}{generic_spct}(x, byref = TRUE, strict.range = NA,
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{calibration_spct}(x, byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{raw_spct}(x, byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{cps_spct}(x, byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{filter_spct}(x, byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{reflector_spct}(x, byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{object_spct}(x, byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{response_spct}(x, byref = TRUE, strict.range = NA,
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{source_spct}(x, byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = getMultipleWl(x), ...)

\method{check_spct}{chroma_spct}(x, byref = TRUE,
  strict.range = getOption("photobiology.strict.range", default = FALSE),
  multiple.wl = getMultipleWl(x), ...)
}
\arguments{
\item{x}{An R object}

\item{byref}{logical indicating if new object will be created by reference or
by copy of \code{x}}

\item{strict.range}{logical indicating whether off-range values result in an
error instead of a warning, \code{NA} disables the test.}

\item{...}{additional param possible in derived methods}

\item{multiple.wl}{numeric Maximum number of repeated w.length entries with same value.}
}
\description{
Check that an R object contains the expected data members.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function.

\item \code{generic_spct}: Specialization for generic_spct.

\item \code{calibration_spct}: Specialization for calibration_spct.

\item \code{raw_spct}: Specialization for raw_spct.

\item \code{cps_spct}: Specialization for cps_spct.

\item \code{filter_spct}: Specialization for filter_spct.

\item \code{reflector_spct}: Specialization for reflector_spct.

\item \code{object_spct}: Specialization for object_spct.

\item \code{response_spct}: Specialization for response_spct.

\item \code{source_spct}: Specialization for source_spct.

\item \code{chroma_spct}: Specialization for chroma_spct.
}}

\examples{
check_spct(sun.spct)

check_spct(sun.spct)
# try(check_spct(-sun.spct))
# try(check_spct((sun.spct[1, "w.length"] <- 1000)))

}
\seealso{
Other data validity check functions: \code{\link{check_spectrum}},
  \code{\link{check_w.length}}
}
