% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.response.R
\name{response}
\alias{response}
\alias{response.default}
\alias{response.response_spct}
\alias{response.response_mspct}
\title{Integrated response}
\usage{
response(spct, w.band, unit.out, quantity, time.unit, wb.trim, use.hinges, ...)

\method{response}{default}(spct, w.band, unit.out, quantity, time.unit, wb.trim,
  use.hinges, ...)

\method{response}{response_spct}(spct, w.band = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  quantity = "total", time.unit = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...)

\method{response}{response_mspct}(spct, w.band = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  quantity = "total", time.unit = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = getOption("photobiology.use.hinges", default = NULL), ...,
  attr2tb = NULL, idx = !is.null(names(spct)))
}
\arguments{
\item{spct}{an R object of class "generic_spct"}

\item{w.band}{waveband or list of waveband objects or a numeric vector of
length two. The waveband(s) determine the region(s) of the spectrum that
are summarized. If a numeric range is supplied a waveband object is
constructed on the fly from it.}

\item{unit.out}{character Allowed values "energy", and "photon", or its alias
"quantum"}

\item{quantity}{character string One of "total", "average" or "mean",
"contribution", "contribution.pc", "relative" or "relative.pc"}

\item{time.unit}{character or lubridate::duration}

\item{wb.trim}{logical Flag telling if wavebands crossing spectral data boundaries
are trimmed or ignored}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
A named \code{numeric} vector in the case of methods for individual
  spectra, with one value for each \code{waveband} passed to parameter
  \code{w.band}. A \code{data.frame} in the case of collections of spectra,
  containing one column for each \code{waveband} object, an index column with
  the names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  Whether returnes values are expressed in energy-based or photon-based units
  depends on \code{unit.out}. By default values are only integrated, but
  depending on the argument passed to parameter \code{quantity} they can be
  re-expressed as relative fractions or percentages. In the case of vector
  output, \code{names} attribute is set to the name of the corresponding
  waveband unless a named list is supplied in which case the names of the
  list members are used.
}
\description{
Calculate average photon- or energy-based photo-response.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{response_spct}: Method for response spectra.

\item \code{response_mspct}: Calculates response from a \code{response_mspct}
}}

\note{
The parameter \code{use.hinges} controls speed optimization. The
  defaults should be suitable in mosts cases. Only the range of wavelengths
  in the wavebands is used and all BSWFs are ignored.
}
\seealso{
Other response functions: \code{\link{e_response}},
  \code{\link{q_response}}
}
