% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/response.data.r
\docType{data}
\name{photodiode.spct}
\alias{photodiode.spct}
\title{Spectral response of a GaAsP photodiode}
\format{A \code{response_spct} object with 94 rows and 2 variables}
\usage{
photodiode.spct
}
\description{
A dataset containing wavelengths at a 1 nm interval and
  spectral response as \eqn{A / (W / nm)} for GaAsP photodiode type
  G6262 from Hamamatsu. Data digitized from manufacturer's data sheet.
  The value at the peak is 0.19 \eqn{A / W}.
}
\details{
\itemize{ \item w.length (nm). \item s.e.response
(A/W)  }
}
\examples{
photodiode.spct

}
\references{
Hamamatsu (2011) Datasheet: GaAsP Photodiodes G5645 G5842 G6262. Hamamatsu
Photonics KK, Hamamatsu, City.
http://www.hamamatsu.com/jp/en/G6262.html.
Visited 2017-12-15.
}
\seealso{
Other Spectral data examples: \code{\link{A.illuminant.spct}},
  \code{\link{D65.illuminant.spct}},
  \code{\link{Ler_leaf.spct}},
  \code{\link{Ler_leaf_rflt.spct}},
  \code{\link{Ler_leaf_trns.spct}},
  \code{\link{Ler_leaf_trns_i.spct}},
  \code{\link{black_body.spct}}, \code{\link{ccd.spct}},
  \code{\link{clear.spct}}, \code{\link{clear_body.spct}},
  \code{\link{filter_cps.mspct}},
  \code{\link{green_leaf.spct}}, \code{\link{opaque.spct}},
  \code{\link{polyester.spct}},
  \code{\link{sun.daily.data}},
  \code{\link{sun.daily.spct}}, \code{\link{sun.data}},
  \code{\link{sun.spct}}, \code{\link{white_body.spct}},
  \code{\link{white_led.cps_spct}},
  \code{\link{white_led.raw_spct}},
  \code{\link{white_led.source_spct}},
  \code{\link{yellow_gel.spct}}
}
\keyword{datasets}
