% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.of.R
\name{color_of}
\alias{color_of}
\alias{color_of.default}
\alias{color_of.numeric}
\alias{color_of.list}
\alias{color_of.waveband}
\alias{color_of.source_spct}
\alias{color_of.source_mspct}
\alias{colour_of}
\alias{color}
\title{Color of an object}
\usage{
color_of(x, ...)

\method{color_of}{default}(x, ...)

\method{color_of}{numeric}(x, type = "CMF", ...)

\method{color_of}{list}(x, short.names = TRUE, type = "CMF", ...)

\method{color_of}{waveband}(x, short.names = TRUE, type = "CMF", ...)

\method{color_of}{source_spct}(x, type = "CMF", ...)

\method{color_of}{source_mspct}(x, ..., idx = !is.null(names(x)))

colour_of(x, ...)

color(x, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{type}{character telling whether "CMF", "CC", or "both" should be returned.}

\item{short.names}{logical indicating whether to use short or long names for
wavebands}

\item{idx}{logical whether to add a column with the names of the elements of
spct}
}
\value{
A color definition in hexadecimal format as a \code{character} string
  of 7 characters, "#" followed by the red, blue, and green values in
  hexadecimal (scaled to 0 ... 255). In the case of the especialization for
  \code{list}, a list of such definitions is returned. In the case of a
  collection of spectra, a \code{data.frame} with one column with such
  definitions and by default an additional column with names of the spectra
  as index.
}
\description{
A function that returns the equivalent RGB color of an object such as a
spectrum or wavelength.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method (returns always "black").

\item \code{numeric}: Method that returns Color definitions corresponding to
numeric values representing a wavelengths in nm.

\item \code{list}: Method that returns Color of elements in a list.

\item \code{waveband}: Color at midpoint of a \code{\link{waveband}} object.

\item \code{source_spct}: 

\item \code{source_mspct}: 
}}

\note{
When \code{x} is a list but not a waveband, if a method  \code{color_of}
  is not available for the class of each element of the list, then
  \code{color_of.default} will be called.
}
\section{Deprecated}{
 Use of color() is deprecated as this wrapper function
  may be removed in future versions of the package. Use color_of() instead.
}

\examples{
wavelengths <- c(300, 420, 500, 600, NA) # nanometres
color_of(wavelengths)
color_of(waveband(c(300,400)))
color_of(list(blue = waveband(c(400,480)), red = waveband(c(600,700))))
color_of(numeric())
color_of(NA_real_)

color_of(sun.spct)


}
