% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zmspct.classes.R
\name{split2mspct}
\alias{split2mspct}
\alias{split2source_mspct}
\alias{split2response_mspct}
\alias{split2filter_mspct}
\alias{split2reflector_mspct}
\alias{split2solute_mspct}
\alias{split2cps_mspct}
\alias{split2raw_mspct}
\alias{split2calibration_mspct}
\title{Convert a 'wide' or untidy data frame into a collection of spectra}
\usage{
split2mspct(
  x,
  member.class = NULL,
  spct.data.var = NULL,
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)

split2source_mspct(
  x,
  spct.data.var = "s.e.irrad",
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)

split2response_mspct(
  x,
  spct.data.var = "s.e.response",
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)

split2filter_mspct(
  x,
  spct.data.var = "Tfr",
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)

split2reflector_mspct(
  x,
  spct.data.var = "Rfr",
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)

split2solute_mspct(
  x,
  spct.data.var = "K.mole",
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)

split2cps_mspct(
  x,
  spct.data.var = "cps",
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)

split2raw_mspct(
  x,
  spct.data.var = "count",
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)

split2calibration_mspct(
  x,
  spct.data.var = "irrad.mult",
  w.length.var = "w.length",
  idx.var = NULL,
  ncol = 1,
  byrow = FALSE,
  ...
)
}
\arguments{
\item{x}{data frame}

\item{member.class}{character Class of the collection members}

\item{spct.data.var}{character Name of the spectral data argument in the
object constructor for \code{member.class}}

\item{w.length.var}{character Name of column containing wavelength data in
nanometres}

\item{idx.var}{character Name of column containing data to be copied
unchanged to each spct object}

\item{ncol}{integer Number of 'virtual' columns in data}

\item{byrow}{logical If \code{ncol > 1} how to read in the data}

\item{...}{additional named arguments passed to the member constructor
function.}
}
\description{
Convert a data frame object into a "multi spectrum" object by
  constructing a an object of a multi-spct class, converting numeric columns
  other than wavelength into individual spct objects.
}
\seealso{
Other Coercion methods for collections of spectra: 
\code{\link{as.calibration_mspct}()},
\code{\link{as.chroma_mspct}()},
\code{\link{as.cps_mspct}()},
\code{\link{as.filter_mspct}()},
\code{\link{as.generic_mspct}()},
\code{\link{as.object_mspct}()},
\code{\link{as.raw_mspct}()},
\code{\link{as.reflector_mspct}()},
\code{\link{as.response_mspct}()},
\code{\link{as.solute_mspct}()},
\code{\link{as.source_mspct}()},
\code{\link{subset2mspct}()}
}
\concept{Coercion methods for collections of spectra}
