% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.range.r
\name{s_range}
\alias{s_range}
\alias{s_range.default}
\alias{s_range.filter_mspct}
\alias{s_range.source_mspct}
\alias{s_range.response_mspct}
\alias{s_range.reflector_mspct}
\alias{s_range.calibration_mspct}
\alias{s_range.cps_mspct}
\alias{s_range.raw_mspct}
\title{Range of a collection of spectra}
\usage{
s_range(x, na.rm, ...)

\method{s_range}{default}(x, na.rm = FALSE, ...)

\method{s_range}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_range}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_range}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_range}{reflector_mspct}(x, na.rm = FALSE, ...)

\method{s_range}{calibration_mspct}(x, na.rm = FALSE, ...)

\method{s_range}{cps_mspct}(x, na.rm = FALSE, ...)

\method{s_range}{raw_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections of
spectral objects.}

\item{na.rm}{logical. A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  "filter_mspct" object, the returned object is of same class as the
  members of the collection, such as "filter_spct", containing the mean
  spectrum.
}
\description{
A method to compute the range of values across members of a collections of
spectra. Computes the max and min at each wavelength across all the spectra
in the collection returning a spectral object.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{filter_mspct}: 

\item \code{source_mspct}: 

\item \code{response_mspct}: 

\item \code{reflector_mspct}: 

\item \code{calibration_mspct}: 

\item \code{cps_mspct}: 

\item \code{raw_mspct}: 
}}

\note{
Trimming of extreme values and omission of NAs is done separately at
  each wavelength. Interpolation is not applied, so all spectra in \code{x}
  must share the same set of wavelengths.

  Objects of classes raw_spct and cps_spct can contain data from multiple
  scans. This functions are implemented for these classes only for the case
  when all member spectra contain data for a single scan, or spliced into a
  single column in the case of cps_spct members.
}
\seealso{
See \code{\link[base]{Extremes}} details on the \code{min()} and
  \code{max()} methods used for the computations.
}
