% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.new.r
\name{waveband}
\alias{waveband}
\alias{new_waveband}
\title{Waveband constructor method}
\usage{
waveband(
  x = NULL,
  weight = NULL,
  SWF.e.fun = NULL,
  SWF.q.fun = NULL,
  norm = NULL,
  SWF.norm = NULL,
  hinges = NULL,
  wb.name = NULL,
  wb.label = wb.name
)

new_waveband(
  w.low,
  w.high,
  weight = NULL,
  SWF.e.fun = NULL,
  SWF.q.fun = NULL,
  norm = NULL,
  SWF.norm = NULL,
  hinges = NULL,
  wb.name = NULL,
  wb.label = wb.name
)
}
\arguments{
\item{x}{any R object on which applying the function range yields an vector of
two numeric values, describing a range of wavelengths (nm)}

\item{weight}{a character string "SWF" or "BSWF", use NULL (the default) to
indicate no weighting used when calculating irradiance}

\item{SWF.e.fun}{a function giving multipliers for a spectral weighting
function (energy) as a function of wavelength (nm)}

\item{SWF.q.fun}{a function giving multipliers for a spectral weighting
function (quantum) as a function of wavelength (nm)}

\item{norm}{a single numeric value indicating the wavelength at which the SWF
should be normalized to 1.0, in nm. "NULL" means no normalization.}

\item{SWF.norm}{a numeric value giving the native normalization wavelength
(nm) used by SWF.e.fun and SWF.q.fun}

\item{hinges}{a numeric vector giving the wavelengths at which the s.irrad
should be inserted by interpolation, no interpolation is indicated by an
empty vector (numeric(0)), if NULL then interpolation will take place at
both ends of the band.}

\item{wb.name}{character string giving the name for the waveband defined,
default is NULL}

\item{wb.label}{character string giving the label of the waveband to be used
for plotting, default is wb.name}

\item{w.low}{numeric value, wavelength at the short end of the band (nm)}

\item{w.high}{numeric value, wavelength at the long end of the band (nm)}
}
\value{
a \code{waveband} object
}
\description{
Constructor for "waveband" objects that can be used as input when calculating
irradiances.
}
\section{Functions}{
\itemize{
\item \code{new_waveband}: A less flexible variant
}}

\examples{
waveband(c(400,700))

new_waveband(400,700)

}
\seealso{
Other waveband constructors: 
\code{\link{split_bands}()}
}
\concept{waveband constructors}
