% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{convertTfrType}
\alias{convertTfrType}
\title{Convert the "Tfr.type" attribute}
\usage{
convertTfrType(x, Tfr.type = NULL)
}
\arguments{
\item{x}{a filter_spct, object_spct, filter_mspct or object_mspct object.}

\item{Tfr.type}{character One of #internal" or "total".}
}
\value{
\code{x} possibly with the \code{"thickness"} field of the
  \code{"filter.properties"} attribute modified
}
\description{
Function to set the "Tfr.type" attribute and simultaneously converting the
spectral data to correspond to the new type.
}
\details{
Internal transmittance uses as reference the light entering the
  object while total transmittance takes the incident light as reference.
  The conversion is possible only if reflectance is known. Either as
  spectral data in an object_spct object, or a filter_spct object that is
  under the hood an object_spct, or if a fixed reflectance factor applicable
  to all wavelengths is known.
}
\note{
if x is not a \code{filter_spct} object, \code{x} is returned
  unchanged. If or \code{x} does not have the \code{"filter.properties"}
  attribute set and with no missing data, \code{x} is returned with
  \code{Tfr} set to \code{NA} values.
}
\examples{

my.spct <- polyester.spct
filter_properties(my.spct) <- list(Rfr.constant = 0.07,
                                   thickness = 125e-6,
                                   attenuation.mode = "absorption")
convertTfrType(my.spct, Tfr.type = "internal")

}
\seealso{
Other time attribute functions: 
\code{\link{checkTimeUnit}()},
\code{\link{convertThickness}()},
\code{\link{convertTimeUnit}()},
\code{\link{getTimeUnit}()},
\code{\link{setTimeUnit}()}
}
\concept{time attribute functions}
