\name{phmm-package}
\alias{phmm-package}
\docType{package}
\title{
Proportional Hazards with Mixed Model (PHMM)
}
\description{
Fits proportional hazards model incorporating random effects. The function implements an EM agorithm using Markov Chain Monte Carlo at the E-step as described in Vaida and Xu (2000).
}
\details{
\tabular{ll}{
Package: \tab phmm\cr
Version: \tab 0.2\cr
Date: \tab 2008-01-15\cr
Depends: \tab survival\cr
Suggests: \tab lme4\cr
License: \tab GPL2\cr
Packaged: \tab Fri Jul 11 10:33:57 2008; mdonohue\cr
Built: \tab R 2.8.0; universal-apple-darwin8.11.1; 2008-11-29 12:05:00; unix\cr
}

Index:
\preformatted{
AIC.phmm                Akaike Information Criterion for PHMM
cAIC                    Conditional Akaike Information Criterion for
                        PHMM
e1582                   Eastern Cooperative Oncology Group (EST 1582)
linear.predictors       PHMM Design
loglik.cond             PHMM conditional log-likelihood
phmm                    Proportional Hazards Model with Mixed Effects
phmm-package            Proportional Hazards Model with Mixed Effects
phmm.cond.loglik        PHMM conditional log-likelihood
phmm.design             PHMM Design
pseudoPoisPHMM          Pseudo poisson data for fitting PHMM via GLMM
traceHat                Trace of the "hat" matrix from PHMM-MCEM fit
}
}
\author{
Ronghui Xu, Michael Donohue

Maintainer: Michael Donohue \email{mdonohue@ucsd.edu}
}
\references{ Vaida, F. and Xu, R. "Proportional hazards model with random effects", \emph{Statistics in Medicine,} 19:3309-3324, 2000.

Donohue, MC, Overholser, R, Xu, R, and Vaida, F (January 01, 2011). Conditional Akaike information under generalized linear and proportional hazards mixed models. \emph{Biometrika}, 98, 3, 685-700.}
\keyword{ package }
\examples{
n <- 50      # total sample size
nclust <- 5  # number of clusters
clusters <- rep(1:nclust,each=n/nclust)
beta0 <- c(1,2)
set.seed(13)
#generate phmm data set
Z <- cbind(Z1=sample(0:1,n,replace=TRUE),
           Z2=sample(0:1,n,replace=TRUE),
           Z3=sample(0:1,n,replace=TRUE))
b <- cbind(rep(rnorm(nclust),each=n/nclust),rep(rnorm(nclust),each=n/nclust))
Wb <- matrix(0,n,2)
for( j in 1:2) Wb[,j] <- Z[,j]*b[,j]
Wb <- apply(Wb,1,sum)
T <- -log(runif(n,0,1))*exp(-Z[,c('Z1','Z2')]\%*\%beta0-Wb)
C <- runif(n,0,1)
time <- ifelse(T<C,T,C)
event <- ifelse(T<=C,1,0)
mean(event)
phmmd <- data.frame(Z)
phmmd$cluster <- clusters
phmmd$time <- time
phmmd$event <- event

fit.phmm <- phmm(Surv(time, event) ~ Z1 + Z2 + (-1 + Z1 + Z2 | cluster), 
   phmmd, Gbs = 100, Gbsvar = 1000, VARSTART = 1,
   NINIT = 10, MAXSTEP = 100, CONVERG=90)
summary(fit.phmm)
}
