% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JE.R
\name{JE}
\alias{JE}
\title{Shannon's Joint-Entropy \eqn{H(X,Y)}}
\usage{
JE(x, unit = "log2")
}
\arguments{
\item{x}{a numeric joint-probability vector \eqn{P(X,Y)} for
which Shannon's Joint-Entropy \eqn{H(X,Y)} shall be computed.}

\item{unit}{a character string specifying the logarithm unit that shall be used to compute distances that depend on log computations.}
}
\value{
a numeric value representing Shannon's Joint-Entropy in bit.
}
\description{
This funciton computes Shannon's Joint-Entropy \eqn{H(X,Y) = - \sum \sum P(X,Y) *
log2(P(X,Y))} based on a given joint-probability vector \eqn{P(X,Y)}.
}
\examples{

JE(1:100/sum(1:100))

}
\references{
Shannon, Claude E. 1948. "A Mathematical Theory of
Communication". \emph{Bell System Technical Journal} \bold{27} (3): 379-423.
}
\seealso{
\code{\link{H}}, \code{\link{CE}}, \code{\link{KL}}, \code{\link{JSD}}, \code{\link{gJSD}}, \code{\link{distance}}
}
\author{
Hajk-Georg Drost
}
