% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RI.R
\name{RI}
\alias{RI}
\title{Return an expected remigration interval.}
\usage{
RI(s, t, r = NULL, c = NULL, p)
}
\arguments{
\item{s}{Time-conditional probability of survival}

\item{t}{Time-conditional probability of tag retention}

\item{r}{Time-conditional probability of return}

\item{c}{Probability of return}

\item{p}{Annual probability of observation}
}
\value{
Return a remigration interval.\cr
}
\description{
Model of remigration interval\cr
Note that r, s and t are conditional probabilities. If c is null, then return probabilities are 
estimated from r. r can be named vector. For example:\cr
r <- c(r1=0.5, r2=0.60, r3=1) is equivalent to c <- c(c1=0.5, c2=0.3, c3=0.2)\cr
The vector of r described the probability that a female returned after 
1, 2, 3 years among those who have not nested before. 
The vector of r is the same but defining the return probability for an initial female.\cr
}
\details{
RI returns an expected remigration interval
}
\examples{
\dontrun{
library(phenology)
# Example
s <- c(s1=1, s2=1, s3=1, s4=1, s5=1)
t <- c(t1=0.95, t2=1, t3=1, t4=1, t5=1) 
r <- c(r1=0.1, r2=0.8, r3=0.7, r4=0.7, r5=1)
p <- c(p1=0.6, p2=0.6, p3=0.6, p4=0.6, p5=0.6)

# r is equivalent to 
c <- c(c1=0.1, c2=0.72, c3=0.126, c4=0.0378, c5=0.0162)
# Then the true remigration interval is:
ri_true <- sum(1:5*c[1:5])

s_ri  <- NULL
for (sx in seq(from=0.01, to=1, by=0.01)) {
  s[] <- sx
  ri1 <- RI(s=s, t=t, r=r, p=p)
  s_ri  <- c(s_ri,sum(1:5*ri1)/sum(ri1))
}

par(mar=c(4, 4, 1, 1)+0.4)

plot(x=seq(from=0.01, to=1, by=0.01), y=s_ri, type="l", 
     las=1, bty="n", ylim=c(0, 4), 
     xlab="Annuual survival probabilities", ylab="Naive Remigration Interval", 
    main="")
segments(x0=0.01, x1=1, y0=ri_true, y1=ri_true, lty=2, col="red")
legend("topright", legend="True remigration interval", lty=2, col="red")

}
}
\seealso{
Other Model of Remigration Interval: 
\code{\link{Bayesian.remigration}()},
\code{\link{LnRI_norm}()},
\code{\link{plot.Remigration}()}
}
\author{
Marc Girondot
}
\concept{Model of Remigration Interval}
