% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fitRMU.R
\name{plot.fitRMU}
\alias{plot.fitRMU}
\title{Plot the synthesis of RMU fit.}
\usage{
\method{plot}{fitRMU}(x, ..., what = "proportions", aggregate = "both",
  order = NULL, control.legend = list(), show.legend = TRUE)
}
\arguments{
\item{x}{A result file generated by fitRMU}

\item{...}{Parameters used by plot}

\item{what}{Can be proportions, numbers or total}

\item{aggregate}{Can be model of both}

\item{order}{Give the order of series in plot, from bottom to top. Can be used to not show series.}

\item{control.legend}{Parameters send to legend}

\item{show.legend}{If FALSE, does not show legend}
}
\value{
Return Nothing
}
\description{
The function plot.fitRMU plots the results of fitRMU().
}
\details{
plot.fitRMU plots the results of a fit RMU.
}
\examples{
\dontrun{
library("phenology")
RMU.names.AtlanticW <- data.frame(mean=c("Yalimapo.French.Guiana", 
                                         "Galibi.Suriname", 
                                         "Irakumpapy.French.Guiana"), 
                                 se=c("se_Yalimapo.French.Guiana", 
                                      "se_Galibi.Suriname", 
                                      "se_Irakumpapy.French.Guiana"))
data.AtlanticW <- data.frame(Year=c(1990:2000), 
      Yalimapo.French.Guiana=c(2076, 2765, 2890, 2678, NA, 
                               6542, 5678, 1243, NA, 1566, 1566),
      se_Yalimapo.French.Guiana=c(123.2, 27.7, 62.5, 126, NA, 
                                 230, 129, 167, NA, 145, 20),
      Galibi.Suriname=c(276, 275, 290, NA, 267, 
                       542, 678, NA, 243, 156, 123),
      se_Galibi.Suriname=c(22.3, 34.2, 23.2, NA, 23.2, 
                           4.3, 2.3, NA, 10.3, 10.1, 8.9),
      Irakumpapy.French.Guiana=c(1076, 1765, 1390, 1678, NA, 
                               3542, 2678, 243, NA, 566, 566),
      se_Irakumpapy.French.Guiana=c(23.2, 29.7, 22.5, 226, NA, 
                                 130, 29, 67, NA, 15, 20))
                           
cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
               colname.year="Year", model.trend="Constant", 
               model.SD="Zero")
expo <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
               colname.year="Year", model.trend="Exponential", 
               model.SD="Zero")
YS <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific", 
             model.SD="Zero")
YS1 <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific", 
             model.SD="Zero", model.rookeries="First-order")
YS1_cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific", 
             model.SD="Constant", model.rookeries="First-order", 
             parameters=YS1$par)
YS2 <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific",
             model.SD="Zero", model.rookeries="Second-order", 
             parameters=YS1$par)
YS2_cst <- fitRMU(RMU.data=data.AtlanticW, RMU.names=RMU.names.AtlanticW, 
             colname.year="Year", model.trend="Year-specific",
             model.SD="Constant", model.rookeries="Second-order", 
             parameters=YS1_cst$par)
               
compare_AIC(Constant=cst, Exponential=expo, 
YearSpecific=YS)

compare_AIC(YearSpecific_ProportionsFirstOrder_Zero=YS1,
YearSpecific_ProportionsFirstOrder_Constant=YS1_cst)

compare_AIC(YearSpecific_ProportionsConstant=YS,
           YearSpecific_ProportionsFirstOrder=YS1,
           YearSpecific_ProportionsSecondOrder=YS2)
           
compare_AIC(YearSpecific_ProportionsFirstOrder=YS1_cst,
           YearSpecific_ProportionsSecondOrder=YS2_cst)

barplot_errbar(YS1_cst$proportions[1, ], y.plus = YS1_cst$proportions.CI.0.95[1, ], 
y.minus = YS1_cst$proportions.CI.0.05[1, ], las=1, ylim=c(0, 0.7), 
main="Proportion of the different rookeries in the region")

plot(cst, main="Use of different beaches along the time", what="total")
plot(expo, main="Use of different beaches along the time", what="total")
plot(YS2_cst, main="Use of different beaches along the time", what="total")

plot(YS1, main="Use of different beaches along the time")
plot(YS1_cst, main="Use of different beaches along the time")
plot(YS1_cst, main="Use of different beaches along the time", what="numbers")

parpre <- par(mar=c(4, 4, 2, 5)+0.4)
par(xpd=TRUE)
plot(YS, main="Use of different beaches along the time", 
control.legend=list(x=2000, y=0.4, legend=c("Yalimapo", "Galibi", "Irakumpapy")))
par(mar=parpre)

# Example to modify order of series
plot(cst, order=c("Galibi.Suriname", "Irakumpapy.French.Guiana"))
plot(cst, order=c("Galibi.Suriname", "Irakumpapy.French.Guiana", "Yalimapo.French.Guiana"))
}
}
\seealso{
Other Fill gaps in RMU: \code{\link{fitRMU_MHmcmc_p}},
  \code{\link{fitRMU_MHmcmc}}, \code{\link{fitRMU}},
  \code{\link{logLik.fitRMU}}
}
\author{
Marc Girondot
}
