% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/result_Gratiot.R
\docType{data}
\name{result_Gratiot}
\alias{result_Gratiot}
\title{Result of the fit of Leatherback nest counts}
\format{A list with Gratiot data and the result of the fit.}
\usage{
result_Gratiot
}
\description{
Result of the fit of Leatherback nest counts from Gratiot et al. (2006) Figure 1
The phenology has been fitted with MinE, MinB, Max, Flat, LengthB, LengthE, Peak, Theta.
}
\details{
Result of the fit of Leatherback nest counts from Gratiot et al. (2006) Figure 1
}
\examples{
\dontrun{
library(phenology)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg <- par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot <- fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL)
# Read a file with result
data(result_Gratiot)
}
}
\references{
Gratiot, N., Gratiot, J., de Thoisy, B. & Kelle, L. 2006. 
            Estimation of marine turtles nesting season from incomplete 
            data ; statistical adjustment of a sinusoidal function. Animal 
            Conservation, 9, 95-102.
}
\author{
Marc Girondot \email{marc.girondot@u-psud.fr}
}
\keyword{datasets}
