#' print.phenologyout prints the information from a result object.
#' @title Print the information from a ouput object.
#' @author Marc Girondot
#' @return None\cr
#' @param x An output generated by plot_phenology
#' @param ... Not used
#' @description The function print.phenologyout displays the output from a plot.
#' @examples
#' library(phenology)
#' # Read a file with data
#' # Gratiot<-read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", , header=FALSE)
#' data(Gratiot)
#' # Generate a formatted list nammed data_Gratiot 
#' data_Gratiot<-add_format(origin=NULL, add=Gratiot, name="Complete", reference=as.Date("2001-01-01"), format="%d/%m/%Y")
#' # Generate initial points for the optimisation
#' parg<-par_init(data_Gratiot, parametersfixed=NULL)
#' # Run the optimisation
#' # result_Gratiot<-fit_phenology(data=data_Gratiot, parametersfit=parg, parametersfixed=NULL, trace=1)
#' data(result_Gratiot)
#' # Plot the phenology and get some stats
#' output<-plot_phenology(result=result_Gratiot, pdf=FALSE)
#' # Show the output
#' output
#' @method print phenologyout
#' @export


print.phenologyout <- function(x, ...) {

	cat(paste("\nNumber of timeseries: ", length(x), "\n", sep=""))
	for (i in 1:length(x)) {
		nmser <- names(x)[i]
		cat(paste("\n", nmser, "\n", sep=""))
		cat(rep("-", nchar(nmser)), "\n", sep="")

	
	mnponte<-x[[i]]$estimates[1]
	sdponte<-x[[i]]$estimates[2]

	cat("Estimation without the observed data\n")
	if (sdponte>=1e-4) {
		cat("Total number of counts: ", format(mnponte, digits=floor(log10(mnponte)+4)), " ; SD ", format(sdponte, digits=floor(log10(sdponte)+4)), "\n", sep="")
	} else {
		cat("Total number of counts: ", format(mnponte, digits=floor(log10(mnponte)+4)), " ; SD 0.000\n", sep="")
	}

	mnponte<-x[[i]]$estimates[3]
	sdponte<-x[[i]]$estimates[4]

	cat("Estimation taking into account the observed data\n")
	if (sdponte>=1e-4) {
		cat("Total number of counts: ", format(mnponte, digits=floor(log10(mnponte)+4)), " ; SD ", format(sdponte, digits=floor(log10(sdponte)+4)), "\n", sep="")
	} else {
		cat("Total number of counts: ", format(mnponte, digits=floor(log10(mnponte)+4)), " ; SD 0.000\n", sep="")
	}

	mnponte1<-x[[i]]$estimates[5]
	mnponte2<-x[[i]]$estimates[6]

	cat("95% confidence interval: ", format(mnponte1, digits=floor(log10(mnponte1)+4)), " - ", format(mnponte2, digits=floor(log10(mnponte2)+4)))

	}

}
