% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/par_init.R
\name{par_init}
\alias{par_init}
\title{Calculate initial set of parameters.}
\usage{
par_init(
  data = stop("A dataset must be provided"),
  fixed.parameters = NULL,
  add.cofactors = NULL
)
}
\arguments{
\item{data}{Dataset generated with add_phenology()}

\item{fixed.parameters}{Set of fixed parameters}

\item{add.cofactors}{Names of cofactors that will be used (see fit_phenology)}
}
\value{
The initial set of parameters
}
\description{
This function is used to generate an initial set of parameters for fitting
that is expected to be not to far from the final.\cr
The parameters can be:\cr
\itemize{
\item \code{Min}, \code{MinE}, \code{MinB}, \code{PMin}, \code{PMinB}, \code{PMinE};
\item \code{Max};
\item \code{Begin}, \code{Peak}, \code{Flat}, \code{End};
\item \code{Length}, \code{LengthB}, \code{LengthE};
\item \code{Theta};
\item \code{Alpha}, \code{Beta}, \code{Tau}, \code{Phi}, \code{Delta};
\item \code{Alpha1}, \code{Beta1}, \code{Tau1}, \code{Phi1}, \code{Delta1};
\item \code{Alpha2}, \code{Beta2}, \code{Tau2}, \code{Phi2}, \code{Delta2};
\item \code{Alpha3}, \code{Beta3}, \code{Tau3}, \code{Phi3}, \code{Delta3};
}
And the name of level if a cofactor is used.\cr
The parameters \code{Max}, \code{Min}, \code{MinE}, \code{MinB}, \code{Length},
\code{LengthB}, \code{LengthE}, and \code{Peak} can be followed with _ and part of the
name of the rookery.\cr
The model for scale effect of sinusoid is: Alpha + Beta * n(t) ^ Tau where
n(t) is the expected number for the day t without the sinusoid effect.
}
\details{
par_init calculates initial set of parameters.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg <- par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot <- fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL)
data(result_Gratiot)
# Plot the phenology and get some stats
output<-plot(result_Gratiot)

## When a series has only 0, it should be used in two steps
## Let see an example

# Let create a times series with only 0
data0 <- data.frame(Date=c("11/3/2015", "12/3/2015", "13/3/2015-18/3/2015", "25/3/2015"), 
                    Number=c(0, 0, 0, 0), 
                    Beach=rep("Site0", 4), stringsAsFactors=FALSE)
data1 <- data.frame(Date=c("15/3/2015", "16/3/2015", "20/3/2015-22/3/2015", "25/3/2015"), 
                    Number=c(1, 0, 3, 0), 
                    Beach=rep("Site1", 4), stringsAsFactors=FALSE)
data <- rbind(data0, data1)

# Here I include timeseries with no observation
try1 <- add_phenology(data, format="\%d/\%m/\%Y", month_ref=1, include0=TRUE)
pfixed <- c(Min=0, Flat=0)
parg <- par_init(try1, fixed.parameters=pfixed)
# The Max value for the series without observations should not be fitted. The ML is for Max being 0
pfixed <- c(pfixed, parg[(substr(names(parg), 1, 4)=="Max_") & (parg == 0)])
parg <- parg[!(names(parg) \%in\% names(pfixed))]

}
}
\seealso{
Other Phenology model: 
\code{\link{AutoFitPhenology}()},
\code{\link{BE_to_LBLE}()},
\code{\link{Gratiot}},
\code{\link{LBLE_to_BE}()},
\code{\link{LBLE_to_L}()},
\code{\link{L_to_LBLE}()},
\code{\link{MarineTurtles_2002}},
\code{\link{MinBMinE_to_Min}()},
\code{\link{adapt_parameters}()},
\code{\link{add_SE}()},
\code{\link{add_phenology}()},
\code{\link{extract_result}()},
\code{\link{fit_phenology}()},
\code{\link{likelihood_phenology}()},
\code{\link{logLik.phenology}()},
\code{\link{map_Gratiot}},
\code{\link{map_phenology}()},
\code{\link{phenology}()},
\code{\link{phenology2fitRMU}()},
\code{\link{phenology_MHmcmc}()},
\code{\link{phenology_MHmcmc_p}()},
\code{\link{plot.phenology}()},
\code{\link{plot.phenologymap}()},
\code{\link{plot_delta}()},
\code{\link{plot_phi}()},
\code{\link{print.phenology}()},
\code{\link{print.phenologymap}()},
\code{\link{print.phenologyout}()},
\code{\link{remove_site}()},
\code{\link{result_Gratiot}},
\code{\link{result_Gratiot1}},
\code{\link{result_Gratiot2}},
\code{\link{result_Gratiot_Flat}},
\code{\link{summary.phenology}()},
\code{\link{summary.phenologymap}()},
\code{\link{summary.phenologyout}()}
}
\author{
Marc Girondot
}
\concept{Phenology model}
