#' summary.phenologyout prints the information from a result object.
#' @title Print the summary information from a ouput object.
#' @author Marc Girondot
#' @return None
#' @param object An output generated by plot.phenology() ou summary.phenology()
#' @param ... Not used
#' @description The function summary.phenologyout displays the output from a plot.
#' @family Phenology model
#' @examples
#' \dontrun{
#' library(phenology)
#' # Read a file with data
#' data(Gratiot)
#' # Generate a formatted list nammed data_Gratiot 
#' data_Gratiot <- add_phenology(Gratiot, name="Complete", 
#' 		reference=as.Date("2001-01-01"), format="%d/%m/%Y")
#' # Generate initial points for the optimisation
#' parg<-par_init(data_Gratiot, fixed.parameters=NULL)
#' # Run the optimisation
#' result_Gratiot <- fit_phenology(data=data_Gratiot, 
#' 		fitted.parameters=parg, fixed.parameters=NULL)
#' data(result_Gratiot)
#' # Plot the phenology and get some stats
#' output <- plot(result_Gratiot)
#' # Show the output
#' summary(output)
#' }
#' @method summary phenologyout
#' @export


summary.phenologyout <- function(object, ...) {

  x<- object
  
  cat(paste("Number of timeseries: ", nrow(x$synthesis), "\n", sep=""))
  for (i in 1:nrow(x$synthesis)) {
    cat(paste(rownames(x$synthesis)[i], "\n", sep=""))
  }
  
}
