% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_input.R
\name{plot_input}
\alias{plot_input}
\title{Plot INPUT returned by check_input}
\usage{
plot_input(INPUT, wmin = 0.2, show.y0 = TRUE, ylab = "VI", ...)
}
\arguments{
\item{INPUT}{A list object with the elements of \code{t}, \code{y}, \code{w},
\code{Tn} (optional) and \code{ylu}, returned by \code{\link[=check_input]{check_input()}}.}

\item{wmin}{Double, minimum weigth (i.e. weight of snow, ice and cloud).}

\item{show.y0}{boolean. Whether to show original time-series \code{y0} or processed time-series \code{y} by
\code{\link[=check_input]{check_input()}}?}

\item{ylab}{y axis title}

\item{...}{other parameter will be ignored.}
}
\description{
Plot INPUT returned by check_input
}
\examples{
library(phenofit)
data("CA_NS6"); d = CA_NS6
# global parameter
IsPlot = TRUE
nptperyear = 23
ypeak_min  = 0.05

INPUT    <- check_input(d$t, d$y, d$w, d$QC_flag, nptperyear,
                        maxgap = nptperyear/4, alpha = 0.02, wmin = 0.2)
plot_input(INPUT)
}
