% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_phenocam.r
\name{write_phenocam}
\alias{write_phenocam}
\title{Write a phenocamr data structure to file}
\usage{
write_phenocam(df = NULL, out_dir = tempdir())
}
\arguments{
\item{df}{a nested data structure of class phenocamr}

\item{out_dir}{output directory where to store data}
}
\value{
writes PhenoCam data structure to file, retains proper header info
and inserts a processing time stamp.
}
\description{
Writes a nested data structure of class phenocamr to file, reconstructing
the original data structure from included headers and data components.
}
\examples{

\donttest{
# download demo data (do not smooth)
download_phenocam(site = "harvard$",
                  veg_type = "DB",
                  roi_id = "1000",
                  frequency = "3",
                  smooth = FALSE)

# read the phenocamo data file
df = read_phenocam(file.paste(tempdir(),"harvard_DB_1000_3day.csv"))

# print data structure
print(summary(df))
 
# write the phenocamo data file
write_phenocam(df, out_dir = tempdir())
}
}
\keyword{phenocam}
\keyword{series,}
\keyword{smoothing,}
\keyword{time}
