% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ph_stickleback}
\alias{ph_stickleback}
\title{Data from: Sexually mediated phenotypic variation within and between sexes as a continuum structured by ecology: The mosaic nature of skeletal variation across body regions in Threespine stickleback (Gasterosteus aculeatus L.)}
\format{
\subsection{\code{ph_stickleback}}{

A data frame of Procrustes superimposed shape data with 190 rows and 214 columns:
\describe{
\item{Biosample}{Biosample}
\item{Habitat}{Habitat}
\item{Population}{Population}
\item{Sex}{Sex}
...
}
}
}
\source{
Downloaded from
<\doi{doi.org/10.5061/dryad.xd2547dkw}>
}
\usage{
ph_stickleback
}
\description{
Abstract: Ecological character displacement between the sexes, and sexual selection, integrate into a convergent set of
factors that produce sexual variation. Ecologically-modulated, sexually mediated variation within and between
sexes may be a major contributor to the amount of total variation that selection can act on in species. Threespine
stickleback (Gasterosteus aculeatus) display rapid adaptive responses and sexual variation in many phenotypic
traits. We examined phenotypic variation in the skull, pectoral and pelvic girdles of threespine stickleback from
two freshwater and two coastal marine sites on the Sunshine Coast of British Columbia, Canada, using an approach
that avoids a priori assumptions about bimodal patterns of variation. We quantified shape and size of the cranial,
pectoral and pelvic regions of sticklebacks in marine and freshwater habitats using 3D geometric morphometrics and
an index of sexually mediated variation. We show that the expression of phenotypic variation is structured in part
by the effects of both habitat marine vs freshwater and the effects of individual sites within each habitat.
Relative size exerts variable influence, and patterns of phenotypic variation associated with sex vary among body
regions. This fine-grained quantification of sexually mediated variation in the context of habitat difference and
different anatomical structures indicates a complex relationship between genetically inferred sex and environmental
factors, demonstrating that the interplay between shared genetic background and sexually mediated, ecologically-
based selective pressures structures the phenotypic expression of complex traits.
}
\keyword{datasets}
