% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example1.R
\name{example1}
\alias{example1}
\title{Example ODE system 1}
\usage{
example1(t, y, parameters)
}
\arguments{
\item{t}{The value of \ifelse{html}{\out{<i>t</i>}}{\eqn{t}}, the independent
variable, to evaluate the derivative at. Should be a
\code{\link[base]{numeric}} \code{\link[base]{vector}} of
\code{\link[base]{length}} one.}

\item{y}{The value of \ifelse{html}{\out{<i>y</i>}}{\eqn{y}}, the dependent
variable, to evaluate the derivative at. Should be a
\code{\link[base]{numeric}} \code{\link[base]{vector}} of
\code{\link[base]{length}} one.}

\item{parameters}{The values of the parameters of the system. Not used here.}
}
\value{
Returns a \code{\link[base]{list}} containing the value of the
derivative at \ifelse{html}{\out{(<i>t</i>, <i>y</i>)}}{\eqn{(t, y)}}.
}
\description{
The derivative function of an example one-dimensional autonomous ODE system.
}
\details{
\code{example1} evaluates the derivative of the following ODE at the point
\ifelse{html}{\out{(<i>t</i>, <i>y</i>)}}{\eqn{(t, y)}}:

\ifelse{html}{\out{<center><i>dy</i>/<i>dt</i> = 4 -
<i>y</i><sup>2</sup>.</center>}}{\deqn{\frac{dy}{dt} = 4 - y^2.}}

Its format is designed to be compatible with \code{\link[deSolve]{ode}} from
the \code{\link[deSolve]{deSolve}} package.
}
\seealso{
\code{\link[deSolve]{ode}}
}
\author{
Michael J Grayling
}
