% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{eff}
\alias{eff}
\title{Efficacy response generation parameters}
\format{An object of class \code{list} of length 4.}
\usage{
eff
}
\value{
\item{Dose_Cycle_Meff}{Dose-cycle mean efficacy matrix. An array of 4
  dimension providing the mean of the multivariate Gaussian distribution in
  efficacy data generation. The dimension of the Dose-cycle mean efficacy
  matrix is 5 5 6 6 which represents dose efficacy pattern, cycle efficacy
  pattern, dose and cycle. Patterns are ordered in a way that the first is
  increasing, the second is flat, the third is platform, the fourth is
  decreasing, and the fifth is quadratic efficacy across dose levels and
  cycles.}

  \item{Sigma}{A 6 by 6 matrix, the covariance matrix of the multivariate
  Guassian distribution in efficacy data generation.}

  \item{sd_trans}{A positive number controls the skewness of the distribution
  of the efficacy response}

  \item{eff.M}{An array recording the corresponding mean of the generated
  efficacy data with parameters specified by \code{eff$Dose_Cycle_Meff},
  \code{eff$Sigma}, and \code{eff$sd_trans}}
}
\description{
A list of 4 records the parameters for efficacy measure generation. This
serves as an example of the parameter settings for efficacy measure
generation in function \code{SimPRMD}. Check \code{\link{eff_summary}} or
\code{\link{SimPRMD}} to see the examples of using dataset \code{eff} in
generating efficacy measure.
}
\keyword{datasets}
