% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{add_iov}
\alias{add_iov}
\title{add_iov}
\usage{
add_iov(
  model,
  occ,
  list_of_parameters = NULL,
  eta_names = NULL,
  distribution = "disjoint"
)
}
\arguments{
\item{model}{(Model) Pharmpy model to add new IOVs to.}

\item{occ}{(str) Name of occasion column.}

\item{list_of_parameters}{(array(str) or str (optional)) List of names of parameters and random variables. Accepts random variable names, parameter
names, or a mix of both.}

\item{eta_names}{(array(str) or str (optional)) Custom names of new etas. Must be equal to the number of input etas times the number of
categories for occasion.}

\item{distribution}{(str) The distribution that should be used for the new etas. Options are
'disjoint' for disjoint normal distributions, 'joint' for joint normal
distribution, 'explicit' for an explicit mix of joint and disjoint
distributions, and 'same-as-iiv' for copying the distribution of IIV etas.}
}
\value{
(Model) Pharmpy model object
}
\description{
Adds IOVs to :class:\code{pharmpy.model}.

Initial estimate of new IOVs are 10\% of the IIV eta it is based on.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- add_iov(model, "TIME", "CL")
model$statements$find_assignment("CL")
}
}
\seealso{
add_iiv

add_pk_iiv

remove_iiv

remove_iov
}
