% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.phantom.R
\name{run.phantom}
\alias{run.phantom}
\title{Run phantom analysis}
\usage{
run.phantom(data = NULL, geneset_list = NULL, query_geneset = NULL,
  ncluster = 2, nsample = 1000)
}
\arguments{
\item{data}{User provided time-course data loaded by load.data()}

\item{geneset_list}{User provided genesets list loaded by load.geneset(). Phanotm package provids four geneset lists from different resources: kegg, reactome, emory geneset and baylor modules. These genesets can be obtained with data(), e.g. data(kegg.geneset)}

\item{query_geneset}{The name of a geneset user wants to analysis. This geneset should be from the geneset_list designated by geneset_list parameter}

\item{ncluster}{The number of clusters within a geneset user wants to use to identify the heterogeneity of this geneset.}

\item{nsample}{The times of random sampling that is used to build the NULL distribution for parato front analysis.}
}
\description{
This function allows user to run individual geneset heterogeneity analysis with phantom
}
\examples{
## load in the demo data in phantom package
data("time.course.data")

## store the analysis result in an object
\dontrun{
obj = run.phantom(data = time.course.data, geneset_list = reactome.geneset,
                  query_geneset ='REACTOME_ANTIVIRAL_MECHANISM_BY_IFN_STIMULATED_GENES',
                  ncluster = 2, nsample = 1000)
}
}
\keyword{phantom}
\keyword{run}
