% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo.R
\name{pml.control}
\alias{pml.control}
\alias{ratchet.control}
\title{Auxiliary for Controlling Fitting}
\usage{
pml.control(epsilon = 1e-08, maxit = 10, trace = 1, tau = 1e-08)

ratchet.control(iter = 20L, maxit = 200L, minit = 100L, prop = 1/2)
}
\arguments{
\item{epsilon}{Stop criterion for optimization (see details).}

\item{maxit}{Maximum number of iterations (see details).}

\item{trace}{Show output during optimization (see details).}

\item{tau}{minimal edge length.}

\item{iter}{Number of iterations to stop if there is no change.}

\item{minit}{Minimum number of iterations.}

\item{prop}{Only used if \code{rearrangement=stochstic}. How many NNI moves
should be added to the tree in proportion of the number of taxa.´}

\item{control}{A list of parameters for controlling the fitting process.}
}
\value{
A list with components named as the arguments.
}
\description{
Auxiliary functions for \code{\link{optim.pml}} fitting. Use it to construct
a \code{control} or \code{ratchet.par} argument.
}
\details{
\code{pml.control} controls the fitting process. \code{epsilon} and
\code{maxit} are only defined for the most outer loop, this affects
\code{pmlCluster}, \code{pmlPart} and \code{pmlMix}.  \code{epsilon} is
defined as (logLik(k)-logLik(k+1))/logLik(k+1), this seems to be a good
heuristics which works reasonably for small and large trees or alignments.
If \code{trace} is set to zero than no out put is shown, if functions are
called internally than the trace is decreased by one, so a higher of trace
produces more feedback.
}
\examples{
pml.control()
pml.control(maxit=25)
}
\seealso{
\code{\link{optim.pml}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
