% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networx.R
\name{splitsNetwork}
\alias{splitsNetwork}
\title{Phylogenetic Network}
\usage{
splitsNetwork(dm, splits = NULL, gamma = 0.1, lambda = 1e-06,
  weight = NULL)
}
\arguments{
\item{dm}{A distance matrix.}

\item{splits}{a splits object, containing all splits to consider, otherwise
all possible splits are used}

\item{gamma}{penalty value for the L1 constraint.}

\item{lambda}{penalty value for the L2 constraint.}

\item{weight}{a vector of weights.}
}
\value{
\code{splitsNetwork} returns a splits object with a matrix added.
The first column contains the indices of the splits, the second column an
unconstrained fit without penalty terms and the third column the constrained
fit.
}
\description{
\code{splitsNetwork} estimates weights for a splits graph from a distance
matrix.
}
\details{
\code{splitsNetwork} fits non-negative least-squares phylogenetic networks
using L1 (LASSO), L2(ridge regression) constraints.  The function minimizes
the penalized least squares 
\deqn{\beta = min \sum(dm - X\beta)^2 + \lambda \|\beta \|^2_2 }{ beta = sum(dm - X*beta)^2 + lambda |beta|^2_2 } 
with respect to \deqn{\|\beta \|_1 <= \gamma, \beta >= 0}{ |beta|_1 = gamma, beta >= 0} 
where \eqn{X} is a design matrix constructed with \code{designSplits}.
External edges are fitted without L1 or L2 constraints.
}
\examples{

data(yeast)
dm = dist.ml(yeast)
fit = splitsNetwork(dm)
net = as.networx(fit)
plot(net, "2D")
write.nexus.splits(fit)

}
\references{
Efron, Hastie, Johnstone and Tibshirani (2004) Least Angle
Regression (with discussion) \emph{Annals of Statistics} \bold{32(2)}, 407--499

K. P. Schliep (2009). Some Applications of statistical phylogenetics (PhD
Thesis)
}
\seealso{
\code{\link[phangorn]{distanceHadamard}},
\code{\link[phangorn]{designTree}} \code{\link[phangorn]{consensusNet}},
\code{\link[phangorn]{plot.networx}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
