% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadpexm.R
\name{loadpexm}
\alias{loadpexm}
\title{loadpexm}
\usage{
loadpexm(f.path = NULL)
}
\arguments{
\item{f.path}{This is an optional argument. If having difficulties to find the main file "\code{pexm.so}" (unix) or "\code{pexm.dll}" (windows), the user 
may choose to manually include here the corresponding quoted path to the target directory.}
}
\value{
Indication of whether the JAGS module \pkg{pexm} was correctly loaded in the \code{R} environment.
}
\description{
Function to load the Just Another Gibbs Sampling (JAGS) module \code{pexm} into the \code{R} environment.
}
\details{
The main purpose of the present function is to load the target JAGS module \pkg{pexm} into the R environment. 
The pexm module allows the application of the Piecewise Exponential (PE) distribution in any Bayesian model implemented through JAGS.  
In order to apply this loading routine, it is necessary to have \href{https://mcmc-jags.sourceforge.io}{JAGS} installed in the computer.
The supporting package \pkg{rjags} is also required and it should have been automatically installed together with \pkg{pexm}. 
Important remark for Windows users: the JAGS version 4.3.0 is the one considered in the present implementation of \pkg{pexm}. 
If working with another version, one must download the source code of \pkg{pexm} and then modify the file "Makevars.win" (directory \code{src}). 
In this case, simply adapt the path in \code{JAGS_ROOT} with the correct version number. 
In order to build the present package, the source code of \pkg{runjags} (\emph{Denwood; 2016}) was used as an example. Details about \pkg{pexm} and 
the piecewise exponential model can be found in \emph{Mayrink et al. (2020)}.
}
\examples{
# Load the new module with the command below:
\donttest{ loadpexm() }

}
\references{
DOI:10.18637/jss.v071.i09 (\href{https://www.jstatsoft.org/article/view/v071i09}{Denwood; 2016})

arXiv:2004.12359 (\href{https://arxiv.org/abs/2004.12359}{Mayrink et al.; 2020})
}
\seealso{
\code{\link{pexm}}
}
