% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropRowsWithAllNA.R
\name{dropRowsWithAllNA}
\alias{dropRowsWithAllNA}
\title{Drop NA rows.}
\usage{
dropRowsWithAllNA(data, ignore = NULL)
}
\arguments{
\item{data}{Dataframe to drop rows from.}

\item{ignore}{Names of columns to ignore for determining whether each row had
all missing values.}
}
\value{
A dataframe with rows removed that had all missing values in
non-ignored columns.
}
\description{
Drop rows with all missing (\code{NA}) values.
}
\details{
Drop rows that have no observed values, i.e., all values in the row are
missing (\code{NA}), excluding the ignored columns.
}
\examples{
# Prepare Data
df <- expand.grid(ID = 1:100, time = c(1, 2, 3))
df <- df[order(df$ID),]
row.names(df) <- NULL
df$score1 <- rnorm(nrow(df))
df$score2 <- rnorm(nrow(df))
df$score3 <- rnorm(nrow(df))
df[sample(1:nrow(df), size = 100), c("score1","score2","score3")] <- NA

# Drop Rows with All NA in Non-Ignored Columns
dropRowsWithAllNA(df, ignore = c("ID","time"))
}
\seealso{
Other dataManipulation: 
\code{\link{columnBindFill}()},
\code{\link{convert.magic}()},
\code{\link{dropColsWithAllNA}()},
\code{\link{varsDifferentTypes}()}

Other dataEvaluations: 
\code{\link{dropColsWithAllNA}()},
\code{\link{is.nan.data.frame}()},
\code{\link{not_all_na}()},
\code{\link{not_any_na}()}
}
\concept{dataEvaluations}
\concept{dataManipulation}
