#' Permutation Test for General Dependent Truncation
#'
#' Implementations of permutation approaches to test for quasi-independence.
#' The implemented approaches are powerful against non-monotone alternatives and
#' thereby offer protection against erroneous assumptions of quasi-independence.
#' The proposed tests use either a conditional or a unconditional method to
#' evaluate the permutation p-value.
#' Users also have an option to carry out the proposed permutation tests in a
#' parallel computing fashion.
#'
#' @aliases permDep-packages
#' @useDynLib permDep, .registration = TRUE
#' @docType package
#' @references  Chiou, S.H., Qian, J., and Betensky, R.A. (2017).
#' Permutation Test for General Dependent Truncation. \emph{Techreport}
"_PACKAGE"
NULL
