% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{sortLeafs}
\alias{sortLeafs}
\title{Chromosome wise leaf ordering}
\usage{
sortLeafs(rf, df, method = "seriation", maxSarf = NULL)
}
\arguments{
\item{rf}{Matrix of pairwise recombination frequencies.}

\item{df}{Vector of cluster numbers, created by splitChr(). Zeros indicated filtered markers and will be ignored.}

\item{method}{Name of method. Default: seriation (uses the optimal leaf ordering algorithm from the seriation package). 
Alternatives endlink (order.endlink from gclus) and endlink-global (ignores linkage groups).}

\item{maxSarf}{Maximum number of neighbor to include into SARF extension.}
}
\value{
Vector of global marker order.
}
\description{
Calculates the optimal leaf ordering pairwise for all linkage groups.
}
\examples{
data(simTetra)
simTetrageno <- bases2genotypes(simTetra, 4)
rfMat <- calcRec(simTetrageno, 4)
split <- splitChr(rfMat, nchr = 7)
sortLeafs(rfMat, split)
}

