% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdistMatrix.R
\name{rdistMatrix}
\alias{rdistMatrix}
\title{Rank-based distances between haplotypes in a given partition}
\usage{
rdistMatrix(dend, sep = "-")
}
\arguments{
\item{dend}{A list of nodes that represents the nested partition of haplotypes.}

\item{sep}{A character string separator for concatenating haplotype labels in the
dendrogram if they are undistingushable in the window around the focal SNV.
See the arguments in \code{\link{reconstructPP}}.}
}
\value{
A matrix of pairwise distances between haplotypes.
}
\description{
This function computes the pairwise distances between haplotypes (tips) of the dendrogram based 
on the ranking of the nested partitions in the dendrogram. See the details.
}
\details{
We code the distance between two haplotypes of a dendrogram as the number of inner nodes that
         seperate the haplotypes plus one. That is, we assign the distance between two internal neighbouring 
         nodes as one, and the distance between an internal node and its neighbouring tip as one. To illustrate, 
         consider the following figure of a dendrogram. In the figure, the distance between the haplotypes 2931 and 454 is 3;
         the distance between other haplotypes are given in the table below.

\if{html}{\figure{treedist.png}{options: width = "30\%" alt = "Figure: treedist.png"}}
\if{latex}{\figure{treedist.pdf}{options: width = 10cm}}

\if{html}{\figure{trtable.png}{options: width = "30\%" alt = "Figure: trtable.png"}}
\if{latex}{\figure{trtable.pdf}{options: width = 9cm}}
}
\examples{
data(ex_hapMat_data)
rdend <- reconstructPP(hapMat = ex_hapMat_data, focalSNV = 2, minWindow = 1, sep = "-" )
rdistMatrix(rdend)


}
