% Generated by roxygen2 (4.0.0): do not edit by hand
\name{detect}
\alias{detect}
\title{Detection probability in a single library of size N}
\usage{
detect(lib = libscheme("NNK", 7), size = 10^8)
}
\arguments{
\item{lib}{library used in experiment, defaults to NNK with peptide length 7}

\item{size}{size of the library, defaults to 10^8}
}
\value{
vector of detection probabilities for peptide sequences in each class
}
\description{
The probability that at least one of a number of specific peptide sequences (e. g. the `best' and closely related sequences) is contained in a library
}
\examples{
summary(detect())

require(ggplot2)
lib <- libscheme("NNK", 7)
qplot(detect(lib, size=10^8), weight=di, geom="histogram", data=lib$data)
}

