% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xvalidate.R
\name{compute_fes}
\alias{compute_fes}
\title{Fixed Effects Computation}
\usage{
compute_fes(
  y,
  fes,
  x,
  b,
  insample_obs = rep(1, n),
  onlymus = FALSE,
  tol = 1e-08,
  verbose = FALSE
)
}
\arguments{
\item{y}{Dependent variable (a vector).}

\item{fes}{List of fixed effects.}

\item{x}{Regressor matrix.}

\item{b}{A vector of coefficient estimates.}

\item{insample_obs}{Vector of observations used to estimate the \code{b} coefficients..}

\item{onlymus}{Logical. If \code{TRUE}, returns only the conditional means.}

\item{tol}{A tolerance parameter.}

\item{verbose}{Logical. If \code{TRUE}, prints messages to the console while evaluating.}
}
\value{
If \code{onlymus = TRUE}, the vector of conditional means. Otherwise, a list with two
elements:
\itemize{
\item \code{mu}: conditional means.
\item \code{fe_values}: fixed effects.
}
}
\description{
This function is a helper for \code{xvalidate} that computes FEs using PPML First Order Conditions
(FOCs).
}
