% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{penfaOut}
\alias{penfaOut}
\title{Print estimated parameter matrices}
\usage{
penfaOut(
  object,
  which = c("lambda", "psi", "phi", "tau", "kappa"),
  ...,
  nd = 3L
)
}
\arguments{
\item{object}{An object of class \code{\linkS4class{penfa}}, that is, a
fitted penalized factor model.}

\item{which}{Character denoting the name of the estimated matrix or vector to
display. Possible values are "lambda", "psi", "phi", "tau", and "kappa".
Multiple elements can be specified. By default, all estimated matrices are
shown.}

\item{...}{Additional options.}

\item{nd}{The number of decimal digits to be used.}
}
\value{
List of the estimated parameter matrices and vectors for each group.
}
\description{
A utility that extracts the estimated parameter matrices
and vectors of the penalized factor model for each group and rounds them to
the specified number of decimal digits.
}
\seealso{
\code{\link{penfa}}
}
