% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_lmms.R
\name{summarize_lmms}
\alias{summarize_lmms}
\title{Step 2 of PRC-LMM (computation of the predicted random effects)}
\usage{
summarize_lmms(object, n.cores = 1, verbose = TRUE)
}
\arguments{
\item{object}{a list of objects as produced by \code{\link{fit_lmms}}}

\item{n.cores}{number of cores to use to parallelize the computation
of the cluster bootstrap optimism correction procedure. If 
\code{ncores = 1} (default), no parallelization is done. 
Pro tip: you can use \code{parallel::detectCores()} to check 
how many cores are available on your computer}

\item{verbose}{if \code{TRUE} (default and recommended value), information
on the ongoing computations is printed in the console}
}
\value{
A list containing the following objects:
\itemize{
\item \code{call}: the function call
\item \code{ranef.orig}: a matrix with the predicted random effects
computed for the original data;
\item \code{n.boots}: number of bootstrap samples;
\item \code{boot.ids}: a list with the ids of bootstrapped subjects 
(when \code{n.boots > 0});
\item \code{ranef.boot.train}: a list where each element is a matrix that 
contains the predicted random effects for each bootstrap sample 
(when \code{n.boots > 0});
\item \code{ranef.boot.valid}: a list where each element is a matrix that 
contains the predicted random effects on the original data, based on the 
lmms fitted on the cluster bootstrap samples (when \code{n.boots > 0});
}
}
\description{
This function performs the second step for the estimation
of the PRC-LMM model proposed in Signorelli et al. (2021, 
in review)
}
\examples{
# generate example data
set.seed(1234)
p = 4 # number of longitudinal predictors
simdata = simulate_prclmm_data(n = 100, p = p, p.relev = 2, 
             seed = 123, t.values = c(0, 0.2, 0.5, 1, 1.5, 2))
             
# specify options for cluster bootstrap optimism correction
# procedure and for parallel computing 
do.bootstrap = FALSE
# IMPORTANT: set do.bootstrap = TRUE to compute the optimism correction!
n.boots = ifelse(do.bootstrap, 100, 0)
parallelize = FALSE
# IMPORTANT: set parallelize = TRUE to speed computations up!
if (!parallelize) n.cores = 1
if (parallelize) {
   # identify number of available cores on your machine
   n.cores = parallel::detectCores()
   if (is.na(n.cores)) n.cores = 1
}

# step 1 of PRC-LMM: estimate the LMMs
y.names = paste('marker', 1:p, sep = '')
step1 = fit_lmms(y.names = y.names, 
                 fixefs = ~ age, ranefs = ~ age | id, 
                 long.data = simdata$long.data, 
                 surv.data = simdata$surv.data,
                 t.from.base = t.from.base,
                 n.boots = n.boots, n.cores = n.cores)
                 
# step 2 of PRC-LMM: compute the summaries 
# of the longitudinal outcomes
step2 = summarize_lmms(object = step1, n.cores = n.cores)
}
\references{
Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. arXiv preprint: arXiv:2101.04426.
}
\seealso{
\code{\link{fit_lmms}} (step 1), 
\code{\link{fit_prclmm}} (step 3),
\code{\link{performance_prc}}
}
\author{
Mirko Signorelli
}
