% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oneMarkerDistribution.R
\name{oneMarkerDistribution}
\alias{oneMarkerDistribution}
\title{Genotype distribution for a single marker}
\usage{
oneMarkerDistribution(x, ids, partialmarker, loop_breakers = NULL,
  eliminate = 0, grid.subset = NULL, verbose = TRUE)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{ids}{A numeric with ID labels of one or more pedigree members.}

\item{partialmarker}{Either a \code{marker} object or the name (or index) of a
marker attached to \code{x}.}

\item{loop_breakers}{(Only relevant if the pedigree has loops). A vector with
ID labels of individuals to be used as loop breakers. If NULL (default)
loop breakers are selected automatically. See \code{\link[=breakLoops]{breakLoops()}}.}

\item{eliminate}{A non-negative integer, indicating the number of iterations
in the internal genotype-compatibility algorithm. Positive values can save
time if \code{partialmarker} has many alleles.}

\item{grid.subset}{(Optional; not relevant for most users.) A numeric matrix
describing a subset of all marker genotype combinations for the \code{ids}
individuals. The matrix should have one column for each of the \code{ids}
individuals, and one row for each combination: The genotypes are described
in terms of the matrix \code{M = allGenotypes(n)}, where \code{n} is the number of
alleles for the marker. If the entry in column \code{j} is the integer \code{k}, this
means that the genotype of individual \code{ids[j]} is row \code{k} of \code{M}.}

\item{verbose}{A logical.}
}
\value{
A named \code{k}-dimensional array, where \code{k = length(ids)}, with the
joint genotype distribution for the \code{ids} individuals. The probabilities
are conditional on the known genotypes and the allele frequencies of
\code{partialmarker}.
}
\description{
Computes the genotype probability distribution of one or several pedigree
members, possibly conditional on known genotypes for the marker.
}
\examples{

# Trivial example giving Hardy-Weinberg probabilities
s = singleton(id = 1)
m = marker(s, alleles = 1:2) # equifrequent SNP
oneMarkerDistribution(s, ids = 1, partialmarker = m)

# Conditioning on a partial genotype
genotype(m, id = 1) = c(1, NA)
oneMarkerDistribution(s, ids = 1, partialmarker = m)

# Genotype distribution for a child of heterozygous parents
trio = nuclearPed(father = "fa", mother = "mo", child = "ch")
m1 = marker(trio, fa = 1:2, mo = 1:2)
oneMarkerDistribution(trio, ids = "ch", partialmarker = m1)

# Joint distribution of the parents, given that the child is heterozygous
m2 = marker(trio, ch = 1:2, alleles = 1:2, afreq = c(0.5, 0.5))
oneMarkerDistribution(trio, ids = c("fa", "mo"), partialmarker = m2)

# A different example: The genotype distribution of an individual (id = 5)
# whose half cousin (id = 9) is homozygous for a rare allele.
y = halfCousinPed(degree = 1)
snp = marker(y, `9` = "a", alleles = c("a", "b"), afreq = c(0.01, 0.99))
plot(y, snp)
oneMarkerDistribution(y, ids = 5, partialmarker = snp)

}
\seealso{
\code{\link[=twoMarkerDistribution]{twoMarkerDistribution()}}
}
\author{
Magnus Dehli Vigeland
}
