
## Expanded test script for pedgene package

require(pedgene)

data(example.ped)
data(example.geno)
data(example.map)

######################################
## From Dan Weeks, issues to check
######################################
## 1) missid ="0" when the rest of the ids are character
## 2) skip pedigree checking, checkpeds=TRUE/FALSE
## 3) character alleles
## 4) disconnected pedigrees
## 5) "flipped" 0/2 geno counts

#########################################################
## Original results for this test case, on non-X chrom.
#########################################################
## X-chrom Burden p-val is .00515
## we also do the Davies p-value for the kernel test, so will be slightly different
#$stat.kernel pedl
#[1] 80.10206
#$pval.kernel
#[1] 0.4039026
#$stat.burden
#[1,] 4.895617
#$pval.burden
#[1,] 0.02692495

## base case
pg.out.m2 <- pedgene(ped=example.ped, geno=example.geno, map=example.map, male.dose=2,
                     weights=NULL, checkpeds=TRUE)

# summary/print and plot methods for this object
print.pedgene(pg.out.m2,digits=3)
## standard result to compare against, note pval.kernel.davies different
##    gene chrom stat.kernel pval.kernel stat.burden pval.burden
## AA   AA     1        80.1       0.404        4.90     0.02692
## AX   AX     X       198.2       0.186        7.82     0.00515

## try making ped1 disconeeded by taking 2nd-generation parents away
## results will differ a little
pg.out.m2.rm34 <- pedgene(example.ped[-(3:4),], example.geno, example.map, male.dose=2, checkpeds=FALSE)
pg.out.m2.rm34

## Test character ids, which is robust now because we're now making super-ids by
## pasting ped-person together within the function
options(stringsAsFactors=FALSE)
char.ped <- with(example.ped, data.frame(ped=as.character(ped), person=as.character(person), father=as.character(father), mother=as.character(mother), sex=sex, trait=trait))
options(stringsAsFactors=TRUE)

## as long as subject and ped ids are character, not factor, this will work
## pedgene makes sure to not treat character as factor 
pg.out.m2.char <- pedgene(char.ped, example.geno, example.map, male.dose=2, checkpeds=FALSE)
pg.out.m2.char

## show that it accepts 23 as X, but recodes 23 to X within the function
map23 <- example.map
map23$chrom[map23$chrom=="X"] <- 23
pg.X23.m2 <- pedgene(ped=example.ped, geno=example.geno, map=map23, male.dose=2,
                     weights=NULL, checkpeds=TRUE)

print(pg.X23.m2, digits=3)

# male dose=1
pg.out.m1 <- pedgene(example.ped, example.geno, example.map, male.dose=1)

print(pg.out.m1, digits=3)
##    gene chrom stat.kernel pval.kernel stat.burden pval.burden
## AA   AA     1      80.102      0.4039      4.8956    0.026925
## AX   AX     X      49.140      0.3568      5.2908    0.021438


## test with no map arg (all variants in one gene columns 3:12)
pg.out.nomap <- pedgene(example.ped, example.geno[,1:12])
pg.out.nomap
#      gene   chrom stat.kernel pval.kernel.davies stat.burden pval.burden
# 1 unknown unknown      80.102             0.3926      4.8956    0.026925


## Testing first gene with dose=2-dose
geno.recode <- cbind(example.geno[,1:2], 2-example.geno[,grep("AA", names(example.geno))])
pg.recode <- pedgene(example.ped, geno.recode, male.dose=2)

## note when map not given, assumes all 1 gene, and assigns "unknown" gene/chrom
pg.recode



## weights, Madsen-Browning
maf <- colMeans(example.geno[,-(1:2)]/2)
## maf not correct for X matrix, b/c n-alleles for males is not 2
## so these results will be a little different for X-chrom

pg.out.wts.m2 <- pedgene(example.ped, example.geno, map=example.map,
         weights=1/sqrt((maf*(1-maf))))
# note stat, pval for AX gene don't match pg.out.m2
print(pg.out.wts.m2)

## plot, consider using the unrelated kernel-clustering plot method to show
##       regions of clustering more than expected,
##       plot gene regions separately


## Testing many genes at once:

genobig <- example.geno
mapbig <- example.map
for(k in 2:20) {
  genobig <- cbind(genobig, example.geno[,-(1:2)])
  mapbig <- rbind(mapbig, example.map)
  mapbig$gene[((k-1)*20+1):(20*k)] <- paste(example.map$gene[1:20],k,sep="")
}


pgbig.m2 <- pedgene(example.ped, genobig, mapbig, male.dose=2)
pgbig.m1 <- pedgene(example.ped, genobig, mapbig, male.dose=1)

pgbig.m2
pgbig.m1

