% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendGen.R
\name{appendGen}
\alias{appendGen}
\title{Simulate genotypes for an appended pedigree}
\usage{
appendGen(ped, M, AF = c(), mut.rate = 0)
}
\arguments{
\item{ped}{: Pedigree \code{data.frame} with columns for animal, sire, and dam identification.}

\item{M}{: Genotype \code{data.frame} with rows corresponding to the initial rows of the pedigree and columns corresponding to markers.}

\item{AF}{: Vector of allele frequencies at different loci for the genotypes to be simulated. If no value is provided, it will be estimated from \code{M}.}

\item{mut.rate}{: Vector of mutation rates at different loci for the genotypes to be simulated, default = 0 for no mutation.}
}
\value{
M2 : New simulated genotypes appended to \code{M}.
}
\description{
Simulate genotypes for an appended pedigree to an existing pedigree with genotypes.
}
\details{
Only diploid and bi-allelic situations are covered.
No linkage disequilibrium is simulated.
}
\examples{
nSNP = 100
AF = runif(nSNP, 0.01, 0.99)
mut.rate = runif(nSNP, 0, 10^-5)
ped = data.frame(ID=1:5, SIRE=c(0,0,1,0,3), DAM=c(0,0,2,2,4))
gen = simulateGen(ped, AF, mut.rate)
ped = rbind(ped, data.frame(ID=6:8, SIRE=c(3,6,6), DAM=c(0,4,5)))
gen = appendGen(ped, M=gen, AF)

}
